VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form Form1 
   Caption         =   "Graficadora CNC"
   ClientHeight    =   8265
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11745
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   8265
   ScaleWidth      =   11745
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame2 
      Height          =   5775
      Left            =   9120
      TabIndex        =   12
      Top             =   120
      Width           =   2415
      Begin VB.CommandButton cmdTrazar 
         Caption         =   "&Trazar"
         Height          =   375
         Left            =   480
         TabIndex        =   21
         Top             =   360
         Width           =   1455
      End
      Begin VB.CommandButton cmdSalir 
         Caption         =   "&Salir"
         Height          =   375
         Left            =   480
         TabIndex        =   20
         Top             =   4200
         Width           =   1455
      End
      Begin VB.ListBox lstCodigo 
         BackColor       =   &H80000007&
         ForeColor       =   &H0000FF00&
         Height          =   1035
         ItemData        =   "Form1.frx":34CA
         Left            =   360
         List            =   "Form1.frx":34CC
         TabIndex        =   19
         Top             =   2640
         Width           =   1695
      End
      Begin VB.CommandButton cmdCargar 
         Caption         =   "&Cargar"
         Height          =   375
         Left            =   480
         TabIndex        =   18
         Top             =   2160
         Width           =   1455
      End
      Begin VB.CommandButton cmdLimpiar 
         Caption         =   "&Limpiar"
         Height          =   375
         Left            =   480
         TabIndex        =   17
         Top             =   3720
         Width           =   1455
      End
      Begin VB.CommandButton cmdDetener 
         Caption         =   "Detener"
         Height          =   375
         Left            =   480
         TabIndex        =   16
         Top             =   840
         Width           =   1455
      End
      Begin VB.CommandButton cmdContinuar 
         Caption         =   "Continuar"
         Height          =   375
         Left            =   480
         TabIndex        =   15
         Top             =   1320
         Width           =   1455
      End
      Begin VB.TextBox txtEscala 
         Alignment       =   1  'Right Justify
         BackColor       =   &H80000007&
         ForeColor       =   &H0000FF00&
         Height          =   285
         Left            =   1320
         TabIndex        =   14
         Text            =   "1"
         Top             =   4920
         Width           =   615
      End
      Begin VB.TextBox txtProfundidad 
         Alignment       =   1  'Right Justify
         BackColor       =   &H00000000&
         ForeColor       =   &H0000FF00&
         Height          =   285
         Left            =   1320
         TabIndex        =   13
         Text            =   "100"
         Top             =   5280
         Width           =   615
      End
      Begin VB.Line Line2 
         X1              =   360
         X2              =   2160
         Y1              =   4800
         Y2              =   4800
      End
      Begin VB.Line Line1 
         X1              =   240
         X2              =   2160
         Y1              =   1920
         Y2              =   1920
      End
      Begin VB.Label E 
         Caption         =   "Escala:"
         Height          =   255
         Left            =   360
         TabIndex        =   23
         Top             =   4920
         Width           =   615
      End
      Begin VB.Label Label2 
         Caption         =   "Profundidad:"
         Height          =   255
         Left            =   360
         TabIndex        =   22
         Top             =   5280
         Width           =   975
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Control de Velocidad"
      Height          =   1935
      Left            =   9120
      TabIndex        =   1
      Top             =   6120
      Width           =   2415
      Begin VB.HScrollBar hscPerforacion 
         Height          =   255
         Left            =   360
         Max             =   15
         Min             =   1
         TabIndex        =   3
         Top             =   720
         Value           =   1
         Width           =   1575
      End
      Begin VB.HScrollBar hscDesplazamiento 
         Height          =   255
         Left            =   360
         Max             =   15
         Min             =   1
         TabIndex        =   2
         Top             =   1440
         Value           =   1
         Width           =   1575
      End
      Begin VB.Label Label9 
         Caption         =   "L"
         Height          =   255
         Left            =   2040
         TabIndex        =   11
         Top             =   1080
         Width           =   255
      End
      Begin VB.Label Label8 
         Caption         =   "L"
         Height          =   255
         Left            =   2040
         TabIndex        =   10
         Top             =   360
         Width           =   255
      End
      Begin VB.Label Label7 
         Caption         =   "+"
         Height          =   255
         Left            =   2040
         TabIndex        =   9
         Top             =   1455
         Width           =   135
      End
      Begin VB.Label Label6 
         Caption         =   "+"
         Height          =   255
         Left            =   2040
         TabIndex        =   8
         Top             =   735
         Width           =   135
      End
      Begin VB.Label Label5 
         Caption         =   "_"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   1400
         Width           =   135
      End
      Begin VB.Label Label4 
         Caption         =   "_"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   680
         Width           =   135
      End
      Begin VB.Label Label1 
         Caption         =   "Veloc. de Perforacin:"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   360
         Width           =   1695
      End
      Begin VB.Label Label3 
         Caption         =   "Veloc. de Desplazamiento:"
         Height          =   255
         Left            =   120
         TabIndex        =   4
         Top             =   1080
         Width           =   1935
      End
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000008&
      Height          =   7815
      Left            =   240
      ScaleHeight     =   7755
      ScaleMode       =   0  'User
      ScaleTop        =   -7755
      ScaleWidth      =   8595
      TabIndex        =   0
      Top             =   240
      Width           =   8655
      Begin VB.Label Label10 
         BackColor       =   &H00000000&
         Caption         =   "www.r-luis.xbot.es"
         ForeColor       =   &H0000C000&
         Height          =   255
         Left            =   0
         TabIndex        =   24
         Top             =   0
         Width           =   1335
      End
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   8760
      Top             =   0
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   8160
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'********************************************************
'*                                                      *
'*    El programa permite graficar dibujos de ACAD200   *
'*    es posible escalar el grfico y graduar la velo-  *
'*    cidad.                                            *
'*                                                      *
'*    Alumnos del Colegio Mayor Jujuy                   *
'*                                                      *
'********************************************************

Option Explicit

Private Declare Sub PortOut Lib "IO.DLL" (ByVal Port As Integer, ByVal Data As Byte)
'variables para lectura de cdigo
Dim cCadena As String
Dim cLetra As String * 1
Dim cCodigoP As String * 2
Dim cX As String, cY As String
Dim nComa As Integer, nLargoCad As Integer
Dim n As Integer, nFin As Integer, Rta As Integer
Dim xi As Single, yi As Single

Dim bArriba As Boolean, bSubir As Boolean 'variables para el taladro
'matrices para motores(8 pasos para cada motor)
Dim BitEjeZ(8) As Byte, BitEjeX(8) As Byte, BitEjeY(8) As Byte
'datos para cada elemento de las matrices
Dim nBitx As Integer, nBity As Integer, nBitz As Integer
'variables para retardos
Dim VelocDesp As Integer
Dim VelocPerf As Integer
Dim TT As Integer, T As Integer
'variables para clculo de desplazamiento
Dim nNewX As Single, nNewY As Single, nNewZ As Integer
Dim nPlusx As Single, nPlusy As Single, nPrevx As Single, nPrevy As Single
Dim Profund As Integer, nEscala As Integer, nPrevz As Integer

Private Sub cmdCargar_Click()
    Timer1.Enabled = False
    ' CancelError es True.
    On Error GoTo solucion
    ' Establece los filtros.
    CommonDialog1.Filter = "All Files (*.*)|*.*|Ploter (*.cnc)|*.cnc"
    ' Especifica el filtro predeterminado.
    CommonDialog1.FilterIndex = 2
    ' Presenta el cuadro de dilogo Abrir.
    CommonDialog1.ShowOpen
    Dim lineareg As String
    Open CommonDialog1.FileName For Input As #2
    n = 0
    ' Carga el archivo plt en un list
    While Not EOF(2) ' lee mientras el archivo no termine
        Line Input #2, lineareg ' lee desde la primera linea
        lineareg = Trim(lineareg)
        lstCodigo.AddItem lineareg, n
        n = n + 1
        lstCodigo.Refresh
    Wend
    Close #2
    n = 0
solucion:
    Exit Sub
End Sub

Private Sub cmdContinuar_Click()
    Timer1.Enabled = True
End Sub

Private Sub cmdDetener_Click()
    Timer1.Enabled = False
End Sub

Private Sub cmdLimpiar_Click()
'limpia el list para cargar un nuevo archivo
    nFin = lstCodigo.ListCount
    lstCodigo.ListIndex = 0
    For n = 0 To nFin - 1
        lstCodigo.RemoveItem 0
    Next
    lstCodigo.Refresh
    Picture1.BackColor = &H0
End Sub

Private Sub cmdTrazar_Click()
    nPrevz = 0
    nPrevx = 0
    nPrevy = 0
    bSubir = True
    nNewZ = Val(txtProfundidad.Text)
    Timer1.Enabled = True
End Sub

Private Sub Form_Load()
    'apaga el puerto
    Call PortOut(888, 0)
    Call PortOut(890, 11)
    'carga valores iniciales para la velocidad de motores
    hscPerforacion.Value = 6
    hscDesplazamiento.Value = 8
End Sub

Private Sub Form_Resize()
' si se modifica la ventana y no est minimizado entonces
If WindowState <> 1 Then
    'se desplazan el picture y el frame con sus controles
    Picture1.Width = Form1.Width - 3210
    Picture1.Height = Form1.Height - 960
    Frame1.Left = Form1.Width - 2790
    Frame2.Left = Form1.Width - 2790
    'aqu se mantendran la coordenada de origen de y
    'en la parte inferior de picture aunque este cambie de tamao
    Picture1.ScaleTop = -Picture1.Height
End If
End Sub

Private Sub hscDesplazamiento_Change()
    'muestra el valor de la velocidad en los ejes x,y
    Label9.Caption = hscDesplazamiento.Value
End Sub

Private Sub hscPerforacion_Change()
    'muestra el valor de la velocidad en el eje z
    Label8.Caption = hscPerforacion.Value
End Sub

Private Sub Timer1_Timer()
    nEscala = Val(txtEscala.Text)           'carga la escala
    cCadena = ""                            'limpia la variable que carga la 1 linea
    cCadena = lstCodigo.Text                'lee la primer lnea de cdigo
    nLargoCad = Len(cCadena)                'calcula longitud del cdigo
    cCodigoP = Left(cCadena, 2)             'toma las dos primeras letras de la lnea
    On Error GoTo Solutions                 'por si surge algn error
        
    If cCodigoP = "SP" Then                 'si se lee la ltima lnea de cdigo
        Timer1.Enabled = False              'detiene el timer
        Rta = MsgBox("Grafico Finalizado", vbInformation, "Graficadora CNC") 'y muestra un mensaje de finde trazado
        Call PortOut(888, 0)
        Call PortOut(890, 11)
    End If
    'ahora se incrementa el puntero en el list
    lstCodigo.ListIndex = lstCodigo.ListIndex + 1
    'Aqu se buscan los valores para x y para y
    If nLargoCad > 3 Then
        nComa = InStr(cCadena, ",")         'busca la ubicacin de la coma
        cX = Mid(cCadena, 3, nComa - 3)     'carga el valor para el eje x
        nNewX = Val(cX) * nEscala           'lo multiplica por el valor de la escala
        cY = Mid(cCadena, nComa + 1, nLargoCad - Len(cX) - 1) 'carga el valor para el eje y
        nNewY = Val(cY) * nEscala           'lo multiplica por la escala
    End If
    Timer1.Enabled = False
    Mover
Solutions:
    Exit Sub
End Sub

Private Sub cmdSalir_Click()
    Call PortOut(890, 11)
    Call PortOut(888, 0)
    End
End Sub

Private Sub Mover()
    BitEjeZ(0) = 10
    BitEjeZ(1) = 8
    BitEjeZ(2) = 9
    BitEjeZ(3) = 13
    BitEjeZ(4) = 15
    BitEjeZ(5) = 7
    BitEjeZ(6) = 3
    BitEjeZ(7) = 2
    
    BitEjeX(0) = 1
    BitEjeX(1) = 3
    BitEjeX(2) = 2
    BitEjeX(3) = 6
    BitEjeX(4) = 4
    BitEjeX(5) = 12
    BitEjeX(6) = 8
    BitEjeX(7) = 9
    
    BitEjeY(0) = 16
    BitEjeY(1) = 48
    BitEjeY(2) = 32
    BitEjeY(3) = 96
    BitEjeY(4) = 64
    BitEjeY(5) = 192
    BitEjeY(6) = 128
    BitEjeY(7) = 144
'************************************************************
'Desplazamiento para el eje z
    '-----------si el taladro est abajo debe subir-------------
    If cCodigoP = "PU" Then
    nBitz = 0
Subir:
        VelocPerf = (15 - hscPerforacion.Value) * 10    'velocidad para subir
        If nPrevz > 0 Then          'sube hasta la posicin 0
            nPrevz = nPrevz - 1
            nBitz = Int(nPrevz) Mod 8
            Call PortOut(890, BitEjeZ(nBitz)) 'aqu se manda el dato al puerto
            'Retardo
            For TT = 1 To VelocPerf
                For T = 1 To 10000: Next T
            Next TT
            GoTo Subir
        End If
        'de ahora en ms el taladro permanece arriba
    End If
    '-----------si el taladro est arriba debe bajar------------
    If cCodigoP = "PD" Then
    nBitz = 0
Bajar:
        VelocPerf = (15 - hscPerforacion.Value) * 10    'velocidad para bajar
        If nPrevz < nNewZ Then 'baja hasta la posicion indicada en nNewZ
            nPrevz = nPrevz + 1
            nBitz = Int(nPrevz) Mod 8
            Call PortOut(890, BitEjeZ(nBitz)) 'aqu se manda el dato al puerto
            'Retardo
            For TT = 1 To VelocPerf
                For T = 1 To 10000: Next T
            Next TT
            GoTo Bajar
        End If
        'de ahora en ms el taladro permanece abajo
    End If
    Call PortOut(890, 11)
'************************************************************
'Desplazamiento para los ejes x-y

    '****************************************************
    If cCodigoP = "PU" Then bArriba = False 'sube lpiz
    If cCodigoP = "PD" Then bArriba = True 'baja lpiz
    '****************************************************
graficar:
    VelocDesp = (15 - hscDesplazamiento.Value) * 10
    'busca diferencias entre origen y destino
    If nNewX <> nPrevx Then xi = Abs(nNewX - nPrevx)
    If nNewY <> nPrevy Then yi = Abs(nPrevy - nNewY)
    'segn la diferemcia que exista entre x,y
    'hay tres posibilidades
    'incrementar el eje x, luego calcular el de y
    If xi > yi Then
        nPlusx = 1
        nPlusy = yi / xi
    End If
    'incrementar eje y, luego calcular el de x
    If xi < yi Then
        nPlusx = xi / yi
        nPlusy = 1
    End If
    'incrementar los dos por igual
    If xi = yi Then
        nPlusx = 1
        nPlusy = 1
    End If
    'se actualizan las coordenadas mientras avanza
    If nPrevx < nNewX Then nPrevx = nPrevx + nPlusx
    If nPrevx > nNewX Then nPrevx = nPrevx - nPlusx
    If nPrevy < nNewY Then nPrevy = nPrevy + nPlusy
    If nPrevy > nNewY Then nPrevy = nPrevy - nPlusy
    
    nBitx = Int(nPrevx) Mod 8
    nBity = Int(nPrevy) Mod 8
    Call PortOut(888, BitEjeX(nBitx) + BitEjeY(nBity))
    'pixeliza la lnea en el Picture1 (color rojo)
    If bArriba = True Then Picture1.PSet (nPrevx, -nPrevy), RGB(255, 0, 0)
    'Retardo
    For TT = 1 To VelocDesp
        For T = 1 To 10000: Next T
    Next TT
    'si termina de dibujar detiene el timer
    If nPrevy = nNewY And nPrevx = nNewX Then
        Timer1.Enabled = True
    Else
        GoTo graficar 'Si no termin, sigue graficando
    End If
End Sub







'  Cordiales Saludos
'  y espero lo disfruten
'  R-Luis
'  www.rluis.xbot.es
