;====================== Encabezado ========================
;
; Ero-Pic // De Rueda Luis
; Secuenciador de 8 Canales y 16 efectos.
;
;==========================================================

	LIST      P=16F84
        include "P16F84.inc"

;=================== Mapa de Memoria ======================

estado	equ	0x03	; Haciendo asignaciones
trisa	equ	0x05
trisb	equ	0x06	      
porta	equ	0x05
portb	equ	0x06

llaves	equ	0x0C	; almacenara el estado de las llaves


;============== Configuracin de puertos ==================

        ORG     0x0000
        GOTO    inicio
        ORG     0x0005

inicio	BSF     estado,5	; cambio al banco 1 del pic
        MOVLW   0x1f		
        MOVWF   trisa		; Asigna al puerto A como entrada
        MOVLW   0x00		
        MOVWF   trisb		; y Al puerto B como salida
        BCF     estado,5	; Regresa al banco 0
        CLRF    porta		; limpia el puerto A
        CLRF    portb		; limpia el puerto B


swich   MOVF	porta,0		; carga w con el puerto A
        ANDLW   0x0F		; retiene los 4 bits de interes (las llaves)
	MOVWF   llaves		; y los guarda en llaves
        XORLW   0x00		; verifica si es el primer efecto
        BTFSC   estado,2	; si es as
        CALL    efect1		; lo llama y lo ejecuta
        MOVF    llaves,0	; sino, carga llaves en w
        XORLW   0x01		; y verifica si es el segundo efecto
        BTFSC   estado,2	; si es as
        CALL    efect2		; lo llama y lo ejecuta
        MOVF    llaves,0	; y as con los dems
        XORLW   0x02		; ya me aburr
        BTFSC   estado,2	; como vers el resto es lo mismo
        CALL    efect3
        MOVF    llaves,0
        XORLW   0x03
        BTFSC   estado,2
        CALL    efect4
        MOVF    llaves,0
        XORLW   0x04		
        BTFSC   estado,2
        CALL    efect5
        MOVF    llaves,0
        XORLW   0x05		
        BTFSC   estado,2
        CALL    efect6
        MOVF    llaves,0
        XORLW   0x06		
        BTFSC   estado,2
        CALL    efect7
        MOVF    llaves,0
        XORLW   0x07		
        BTFSC   estado,2
        CALL    efect8
        MOVF    llaves,0
        XORLW   0x08		
        BTFSC   estado,2
        CALL    efect9
        MOVF    llaves,0
        XORLW   0x09		
        BTFSC   estado,2
        CALL    efect10
        MOVF    llaves,0
        XORLW   0x0A		
        BTFSC   estado,2
        CALL    efect11
        MOVF    llaves,0
        XORLW   0x0B		
        BTFSC   estado,2
        CALL    efect12
        MOVF    llaves,0
        XORLW   0x0C		
        BTFSC   estado,2
        CALL    efect13
        MOVF    llaves,0
        XORLW   0x0D		
        BTFSC   estado,2
        CALL    efect14
        MOVF    llaves,0
        XORLW   0x0E		
        BTFSC   estado,2
        CALL    efect15
        MOVF    llaves,0
        XORLW   0x0F		
        BTFSC   estado,2
        CALL    efect16
        GOTO    swich		; Comienza a revisar de nuevo

;======================== Efectos =========================

efect1	CLRF    portb		; limpia el puerto B
        BSF     portb,7		; (10000000)
        CALL    clokon
        BSF     portb,6		; (11000000)
        CALL    clokon
        BSF     portb,5		; (11100000)
        CALL    clokon
        BSF     portb,4		; (11110000)
        CALL    clokon
        BSF     portb,3		; (11111000)
        CALL    clokon
        BSF     portb,2		; (11111100)
        CALL    clokon
        BSF     portb,1		; (11111110)
        CALL    clokon
        BSF     portb,0		; (11111111)
        CALL    clokon
        BCF     portb,7		; (01111111)
        CALL    clokon
        BCF     portb,6		; (00111111)
        CALL    clokon
        BCF     portb,5		; (00011111)
        CALL    clokon
        BCF     portb,4		; (00001111)
        CALL    clokon
        BCF     portb,3		; (00000111)
        CALL    clokon
        BCF     portb,2		; (00000011)
        CALL    clokon
        BCF     portb,1		; (00000001)
        CALL    clokon
        CLRF    portb		; (00000000)
        CALL    clokon
trece	BSF     portb,0		; (00000001)
        CALL    clokon
        BSF     portb,1		; (00000011)
        CALL    clokon
        BSF     portb,2		; (00000111)
        CALL    clokon
        BSF     portb,3		; (00001111)
        CALL    clokon
        BSF     portb,4		; (00011111)
        CALL    clokon
        BSF     portb,5		; (00111111)
        CALL    clokon
        BSF     portb,6		; (01111111)
        CALL    clokon
        BSF     portb,7		; (11111111)
        CALL    clokon
        BCF     portb,0		; (11111110)
        CALL    clokon
        BCF     portb,1		; (11111100)
        CALL    clokon
        BCF     portb,2		; (11111000)
        CALL    clokon
        BCF     portb,3		; (11110000)
        CALL    clokon
        BCF     portb,4		; (11100000)
        CALL    clokon
        BCF     portb,5		; (11000000)
        CALL    clokon
        BCF     portb,6		; (10000000)
        CALL    clokon
        RETURN			; a revisar nuevamente las llaves

efect2	CLRF    portb		; limpia el puerto B
        BSF     portb,7		; (10000000)		EFECTO ACUMULATIVO EN "0"
        CALL    clokon
        BCF     portb,7 	; (00000000)
        BSF     portb,6		; (01000000)
        CALL    clokon
        BCF     portb,6		; (00000000)
        BSF     portb,5		; (00100000)
        CALL    clokon
        BCF     portb,5		; (00000000)
        BSF     portb,4		; (00010000)
        CALL    clokon
        BCF     portb,4		; (00000000)
        BSF     portb,3		; (00001000)
        CALL    clokon
        BCF     portb,3		; (00000000)
        BSF     portb,2		; (00000100)
        CALL    clokon
        BCF     portb,2		; (00000000)
        BSF     portb,1		; (00000010)
        CALL    clokon
        BCF     portb,1		; (00000000)
        BSF     portb,0		; (00000001)
        CALL    clokon
        BSF     portb,7		; (10000001)
        CALL    clokon
        BCF     portb,7		; (00000001)
        BSF     portb,6		; (01000001)
        CALL    clokon
        BCF     portb,6		; (00000001)
        BSF     portb,5		; (00100001)
        CALL    clokon
        BCF     portb,5		; (00000001)
        BSF     portb,4		; (00010001)
        CALL    clokon
        BCF     portb,4		; (00000001)
        BSF     portb,3		; (00001001)
        CALL    clokon
        BCF     portb,3		; (00000001)
        BSF     portb,2		; (00000101)
        CALL    clokon
        BCF     portb,2		; (00000001)
        BSF     portb,1		; (00000011)
        CALL    clokon
        BSF     portb,7		; (10000011)
        CALL    clokon
        BCF     portb,7		; (00000011)
        BSF     portb,6		; (01000011)
        CALL    clokon
        BCF     portb,6		; (00000011)
        BSF     portb,5		; (00100011)
        CALL    clokon
        BCF     portb,5		; (00000011)
        BSF     portb,4		; (00010011)
        CALL    clokon
        BCF     portb,4		; (00000011)
        BSF     portb,3		; (00001011)
        CALL    clokon
        BCF     portb,3		; (00000011)
        BSF     portb,2		; (00000111)
        CALL    clokon
        BSF     portb,7		; (10000111)
        CALL    clokon
        BCF     portb,7		; (00000111)
        BSF     portb,6		; (01000111)
        CALL    clokon
        BCF     portb,6		; (00000111)
        BSF     portb,5		; (00100111)
        CALL    clokon
        BCF     portb,5		; (00000111)
        BSF     portb,4		; (00010111)
        CALL    clokon
        BCF     portb,4		; (00000111)
        BSF     portb,3		; (00001111)
        CALL    clokon
        BSF     portb,7		; (10001111)
        CALL    clokon
        BCF     portb,7		; (00001111)
        BSF     portb,6		; (01001111)
        CALL    clokon
        BCF     portb,6		; (00001111)
        BSF     portb,5		; (00101111)
        CALL    clokon
        BCF     portb,5		; (00001111)
        BSF     portb,4		; (00011111)
        CALL    clokon
        BSF     portb,7		; (10011111)
        CALL    clokon
        BCF     portb,7		; (00011111)
        BSF     portb,6		; (01011111)
        CALL    clokon
        BCF     portb,6		; (00011111)
        BSF     portb,5		; (00111111)
        CALL    clokon
        BSF     portb,7		; (10111111)
        CALL    clokon
        BCF     portb,7		; (00111111)
        BSF     portb,6		; (01111111)
        CALL    clokon
        BSF     portb,7		; (11111111)
        CALL    clokon
        RETURN

efect3	CLRF    portb		; limpia el puerto B
        CALL    clokon
        BSF     portb,0		; (00000001)
        CALL    clokon
        BCF     portb,0		; (00000000)
        BSF     portb,1		; (00000010)
        CALL    clokon
        BCF     portb,1		; (00000000)
        BSF     portb,2		; (00000100)
        CALL    clokon
        BCF     portb,2		; (00000000)
        BSF     portb,3		; (00001000)
        CALL    clokon
        BCF     portb,3		; (00000000)
        BSF     portb,4		; (00010000)
        CALL    clokon
        BCF     portb,4		; (00000000)
        BSF     portb,5		; (00100000)
        CALL    clokon
        BCF     portb,5		; (00000000)
        BSF     portb,6		; (01000000)
        CALL    clokon
        BCF     portb,6		; (00000000)
        BSF     portb,7		; (10000000)
        CALL    clokon
        BSF     portb,0		; (10000001)
        CALL    clokon
        BCF     portb,0		; (10000000)
        BSF     portb,1		; (10000010)
        CALL    clokon
        BCF     portb,1		; (10000000)
        BSF     portb,2		; (10000100)
        CALL    clokon
        BCF     portb,2		; (10000000)
        BSF     portb,3		; (10001000)
        CALL    clokon
        BCF     portb,3		; (10000000)
        BSF     portb,4		; (10010000)
        CALL    clokon
        BCF     portb,4		; (10000000)
        BSF     portb,5		; (10100000)
        CALL    clokon
        BCF     portb,5		; (10000000)
        BSF     portb,6		; (11000000)
        CALL    clokon
        BSF     portb,0		; (11000001)
        CALL    clokon
        BCF     portb,0		; (11000000)
        BSF     portb,1		; (11000010)
        CALL    clokon
        BCF     portb,1		; (11000000)
        BSF     portb,2		; (11000100)
        CALL    clokon
        BCF     portb,2		; (11000000)
        BSF     portb,3		; (11001000)
        CALL    clokon
        BCF     portb,3		; (11000000)
        BSF     portb,4		; (11010000)
        CALL    clokon
        BCF     portb,4		; (11000000)
        BSF     portb,5		; (11100000)
        CALL    clokon
        BSF     portb,0		; (11100001)
        CALL    clokon
        BCF     portb,0		; (11100000)
        BSF     portb,1		; (11100010)
        CALL    clokon
        BCF     portb,1		; (11100000)
        BSF     portb,2		; (11100100)
        CALL    clokon
        BCF     portb,2		; (11100000)
        BSF     portb,3		; (11101000)
        CALL    clokon
        BCF     portb,3		; (11100000)
        BSF     portb,4		; (11110000)
        CALL    clokon
        BSF     portb,0		; (11110001)
        CALL    clokon
        BCF     portb,0		; (11110000)
        BSF     portb,1		; (11110010)
        CALL    clokon
        BCF     portb,1		; (11110000)
        BSF     portb,2		; (11110100)
        CALL    clokon
        BCF     portb,2		; (11110000)
        BSF     portb,3		; (11111000)
        CALL    clokon
        BSF     portb,0		; (11111001)
        CALL    clokon
        BCF     portb,0		; (11111000)
        BSF     portb,1		; (11111010)
        CALL    clokon
        BCF     portb,1		; (11111000)
        BSF     portb,2		; (11111100)
        CALL    clokon
        BSF     portb,0		; (11111101)
        CALL    clokon
        BCF     portb,0		; (11111100)
        BSF     portb,1		; (11111110)
        CALL    clokon
        BSF     portb,0		; (11111111)
        CALL    clokon
        RETURN

efect4	CLRF    portb		; limpia el puerto B
        BSF     portb,7		; (10000000)
	BSF     portb,0		; (10000001)
        CALL    clokon
        BSF     portb,6		; (11000001)
        BSF     portb,1		; (11000011)
        CALL    clokon
        BSF     portb,5		; (11100011)
        BSF     portb,2		; (11100111)
        CALL    clokon
        BSF     portb,4		; (11110111)
        BSF     portb,3		; (11111111)
        CALL    clokon
        BCF     portb,7		; (01111111)
        BCF     portb,0		; (01111110)
        CALL    clokon
        BCF     portb,6		; (00111110)
        BCF     portb,1		; (00111100)
        CALL    clokon
        BCF     portb,5		; (00011100)
        BCF     portb,2		; (00011000)
        CALL    clokon
        BCF     portb,4		; (00001000)
        BCF     portb,3		; (00000000)
        CALL    clokon
        CALL    clokon
        BSF     portb,3		; (00001000)
        BSF     portb,4		; (00011000)
        CALL    clokon
        BSF     portb,5		; (00111000)
        BSF     portb,2		; (00111100)
        CALL    clokon
        BSF     portb,6		; (01111100)
        BSF     portb,1		; (01111110)
        CALL    clokon
        BSF     portb,7		; (11111110)
        BSF     portb,0		; (11111111)
        CALL    clokon
	BCF     portb,3		; (11110111)
        BCF     portb,4		; (11100111)
        CALL    clokon
        BCF     portb,5		; (11000111)
        BCF     portb,2		; (11000011)
        CALL    clokon
        BCF     portb,6		; (10000011)
        BCF     portb,1		; (10000001)
        CALL    clokon
        BCF     portb,7		; (00000001)
        BCF     portb,0		; (00000000)
        CALL    clokon
        RETURN

efect5	CLRF    portb		; limpia el puerto B
	MOVLW	0x01		; comienza con (00000001)
	MOVWF	portb		; lo enva a la salida
cinco   BSF     estado,0	; pone a 0 el bit C de status (carry)
	CALL    clokon
	MOVWF	portb		; lo enva a la salida
        RLF     portb,0		; rota a la derecha y pasa el valor a W
	MOVWF	portb		; lo enva a la salida
	CALL	clokon
	CLRF	portb		; (00000000)
	CALL	clokon
	MOVWF	portb		; repite
	CALL	clokon
	CLRF	portb		; (00000000)
	CALL	clokon
	MOVWF	portb		; lo enva a la salida
        BTFSS   portb,7		; ve si termin de rotar
        GOTO    cinco
	CALL	clokon
        BCF     portb,7		; (01111111)
        CALL    clokon
        BCF     portb,6		; (00111111)
        CALL    clokon
        BCF     portb,5		; (00011111)
        CALL    clokon
        BCF     portb,4		; (00001111)
        CALL    clokon
        BCF     portb,3		; (00000111)
        CALL    clokon
        BCF     portb,2		; (00000011)
        CALL    clokon
        BCF     portb,1		; (00000001)
        CALL    clokon
	RETURN


efect6	CLRF    portb		; limpia el puerto B
	MOVLW	0x01		; comienza con (00000001)
	MOVWF	portb		; lo enva a la salida
tres    BCF     estado,0	; pone a 0 el bit C de status (carry)
	CALL    clokon
	MOVWF	portb		; lo enva a la salida
        RLF     portb,0		; rota a la derecha y pasa el valor a W
	MOVWF	portb		; lo enva a la salida
	CALL	clokon
	CLRF	portb		; (00000000)
	CALL	clokon
	MOVWF	portb		; repite
	CALL	clokon
	CLRF	portb		; (00000000)
	CALL	clokon
	MOVWF	portb		; lo enva a la salida
        BTFSS   portb,7		; ve si termin de rotar
        GOTO    tres
	CALL	clokon
	RETURN

efect7	CLRF    portb		; limpia el puerto B
        CALL    clokon
        BSF     portb,0		; (00000001)
        CALL    clokon
        BCF     portb,0		; (00000000)
        BSF     portb,1		; (00000010)
        CALL    clokon
        BCF     portb,1		; (00000000)
        BSF     portb,2		; (00000100)
        CALL    clokon
        BCF     portb,2		; (00000000)
        BSF     portb,3		; (00001000)
        CALL    clokon
        BCF     portb,3		; (00000000)
        BSF     portb,4		; (00010000)
        CALL    clokon
        BCF     portb,4		; (00000000)
        BSF     portb,5		; (00100000)
        CALL    clokon
        BCF     portb,5		; (00000000)
        BSF     portb,6		; (01000000)
        CALL    clokon
        BCF     portb,6		; (00000000)
        BSF     portb,7		; (10000000)
        CALL    clokon
        BSF     portb,6		; (11000000)
        CALL    clokon
        BCF     portb,6		; (10000000)
        BSF     portb,5		; (10100000)
        CALL    clokon
        BCF     portb,5		; (10000000)
        BSF     portb,4		; (10010000)
        CALL    clokon
        BCF     portb,4		; (10000000)
        BSF     portb,3		; (10001000)
        CALL    clokon
        BCF     portb,3		; (10000000)
        BSF     portb,2		; (10000100)
        CALL    clokon
        BCF     portb,2		; (10000000)
        BSF     portb,1		; (10000010)
        CALL    clokon
        BCF     portb,1		; (10000000)
        BSF     portb,0		; (10000001)
        CALL    clokon
        BSF     portb,1		; (10000011)
        CALL    clokon
        BCF     portb,1		; (10000001)
        BSF     portb,2		; (10000101)
        CALL    clokon
        BCF     portb,2		; (10000001)
        BSF     portb,3		; (10001001)
        CALL    clokon
        BCF     portb,3		; (10000001)
        BSF     portb,4		; (10010001)
        CALL    clokon
        BCF     portb,4		; (10000001)
        BSF     portb,5		; (10100001)
        CALL    clokon
        BCF     portb,5		; (10000001)
        BSF     portb,6		; (11000001)
        CALL    clokon
        BSF     portb,5		; (11100001)
        CALL    clokon
        BCF     portb,5		; (11000001)
        BSF     portb,4		; (11010001)
        CALL    clokon
        BCF     portb,4		; (11000001)
        BSF     portb,3		; (11001001)
        CALL    clokon
        BCF     portb,3		; (11000001)
        BSF     portb,2		; (11000101)
        CALL    clokon
        BCF     portb,2		; (11000001)
        BSF     portb,1		; (11000011)
        CALL    clokon
        BSF     portb,2		; (11000111)
        CALL    clokon
        BCF     portb,2		; (11000011)
        BSF     portb,3		; (11001011)
        CALL    clokon
        BCF     portb,3		; (11000011)
        BSF     portb,4		; (11010011)
        CALL    clokon
        BCF     portb,4		; (11000011)
        BSF     portb,5		; (11100011)
        CALL    clokon
        BSF     portb,4		; (11110011)
        CALL    clokon
        BCF     portb,4		; (11100011)
        BSF     portb,3		; (11101011)
        CALL    clokon
        BCF     portb,3		; (11100011)
        BSF     portb,2		; (11100111)
        CALL    clokon
        BSF     portb,3		; (11101111)
        CALL    clokon
        BCF     portb,3		; (11100111)
        BSF     portb,4		; (11110111)
        CALL    clokon
        BSF     portb,3		; (11111111)
        CALL    clokon
        BCF     portb,2		; (11111011)
        CALL    clokon
        BSF     portb,2		; (11111111)
        CALL    clokon
        BCF     portb,1		; (11111101)
        CALL    clokon
        BSF     portb,1		; (11111111)
        CALL    clokon
        BCF     portb,0		; (11111110)
        CALL    clokon
	BSF     portb,0		; (11111111)
        CALL    clokon
        BCF     portb,0		; (11111110)
        CALL    clokon
        BCF     portb,1		; (11111100)
        CALL    clokon
        BCF     portb,2		; (11111000)
        CALL    clokon
        BCF     portb,3		; (11110000)
        CALL    clokon
        BCF     portb,4		; (11100000)
        CALL    clokon
        BCF     portb,5		; (11000000)
        CALL    clokon
        BCF     portb,6		; (10000000)
        CALL    clokon
        BCF     portb,7		; (00000000)
        CALL    clokon
	RETURN

efect8	CALL	efect3		; combinan el efecto 3
	CALL	efect2		; con el efecto 2
	RETURN

efect9	CLRF    portb		; limpia el puerto B
	MOVLW	0xEE		; comienza con (11101110)
	MOVWF	portb		; lo pasa a portb
	BSF	estado,0	; pone el carry a 1
rotar   CALL    clokon
	RLF	portb,1		; inicia la rotacin
	BTFSC	portb,7		; ve si termin de rotar
	GOTO 	rotar		; sino contina
	CALL	clokon
	RETURN			; termin, ver si cambi efecto

efect10	CLRF    portb		; limpia el puerto B
	MOVLW	0xFE		; comienza con (11111110)
	MOVWF	portb		; lo pasa a portb
	BSF	estado,0	; pone el carry a 1
rotar1  CALL	clokon
	RLF	portb,1		; inicia la rotacin
	BTFSC	portb,7		; ve si termin de rotar
	GOTO 	rotar1		; sino contina
rotar2	CALL	clokon
	RRF	portb,1		; ahora rota al revs
	BTFSC	portb,0		; ve si termin de rotar
	GOTO 	rotar2		; sino contina
	CALL	clokon
	RETURN			; termin, ver si cambi efecto

efect11	CLRF    portb		; limpia el puerto B
	BSF	portb,0		; (00000001)
        CALL    clokon
	BSF	portb,1		; (00000011)
        CALL    clokon
	BSF	portb,2		; (00000111)
        CALL    clokon
	BSF	portb,3		; (00001111)
        CALL    clokon
	BSF	portb,4		; (00011111)
        CALL    clokon
	BSF	portb,5		; (00111111)
        CALL    clokon
	BSF	portb,6		; (01111111)
        CALL    clokon
	BSF	portb,7		; (11111111)
	BCF	estado,0	; pone el carry a 0
uno	CALL	clokon
	RRF	portb,1		; rotar uno apagado
	BTFSC	portb,0		; ve si es (11111110)
	GOTO 	uno		; sino contina
        CALL    clokon
	BCF	portb,1		; (11111100)
        CALL    clokon
	BCF	portb,2		; (11111000)
        CALL    clokon
	BCF	portb,3		; (11110000)
        CALL    clokon
	BCF	portb,4		; (11100000)
        CALL    clokon
	BCF	portb,5		; (11000000)
        CALL    clokon
	BCF	portb,6		; (10000000)
	BCF	estado,0	; pone el carry a 0
dos	CALL	clokon
	RRF	portb,1		; rotar uno encendido
	BTFSS	portb,0		; ve si es (00000001)
	GOTO 	dos		; sino contina
        CALL    clokon
	RETURN			; termin, ver si cambi efecto

efect12	CLRF    portb		; limpia el puerto B
	BSF	portb,0		; (00000001)
        CALL    clokon
	BSF	portb,1		; (00000011)
        CALL    clokon
	BSF	portb,2		; (00000111)
        CALL    clokon
	BSF	portb,3		; (00001111)
        CALL    clokon
	BSF	portb,4		; (00011111)
        CALL    clokon
	BSF	portb,5		; (00111111)
        CALL    clokon
	BSF	portb,6		; (01111111)
        CALL    clokon
	BSF	portb,7		; (11111111)
        CALL    clokon
	CLRF	portb		; (00000000)
        CALL    clokon
	MOVLW	0xFF		 
	MOVWF	portb		; (11111111) enciendo todo
        CALL    clokon
	CLRF	portb		; (00000000)
        CALL    clokon
	MOVLW	0xFF		 
	MOVWF	portb		; (11111111) enciendo todo
        CALL    clokon
	CLRF	portb		; (00000000)
        CALL    clokon
	MOVLW	0xFF		 
	MOVWF	portb		; (11111111) enciendo todo
        CALL    clokon
	CLRF	portb		; (00000000)
        CALL    clokon
	MOVLW	0xFF		 
	MOVWF	portb		; (11111111) enciendo todo
        CALL    clokon
        BCF     portb,7		; (01111111)
        CALL    clokon
        BCF     portb,6		; (00111111)
        CALL    clokon
        BCF     portb,5		; (00011111)
        CALL    clokon
        BCF     portb,4		; (00001111)
        CALL    clokon
        BCF     portb,3		; (00000111)
        CALL    clokon
        BCF     portb,2		; (00000011)
        CALL    clokon
        BCF     portb,1		; (00000001)
        CALL    clokon
	RETURN

efect13	CLRF    portb		; limpia el puerto B
	CALL	trece		; ejecuta parte del efecto 1	
	RETURN

efect14	CLRF    portb		; limpia el puerto B
        BSF     portb,7		; (10000000)	EFECTO ENCIENDE DE AFUERA AL CENTRO
        BSF     portb,0		; (10000001)-----
        CALL    clokon
	CLRF	portb
        BSF     portb,6		; (01000000)
        BSF     portb,1		; (01000010)-----
        CALL    clokon
	CLRF	portb
        BSF     portb,5		; (00100000)
        BSF     portb,2		; (00100100)-----
        CALL    clokon
	CLRF	portb
        BSF     portb,4		; (00010000)
        BSF     portb,3		; (00011000)-----
        CALL    clokon
        BSF     portb,5		; (00111000)
        BSF     portb,2		; (00111100)
        CALL    clokon
        BSF     portb,6		; (01111100)
        BSF     portb,1		; (01111110)
        CALL    clokon
        BSF     portb,7		; (11111110)
        BSF     portb,0		; (11111111)
        CALL    clokon
	BCF     portb,3		; (11110111)
        BCF     portb,4		; (11100111)
        CALL    clokon
        BCF     portb,5		; (11000111)
        BCF     portb,2		; (11000011)
        CALL    clokon
        BCF     portb,6		; (10000011)
        BCF     portb,1		; (10000001)
        CALL    clokon
        BCF     portb,7		; (00000001)
        BCF     portb,0		; (00000000)
        CALL    clokon
        RETURN

efect15	CLRF    portb		; limpia el puerto B
	MOVLW	0x80		; comienza con (10000000)
	MOVWF	portb		; lo enva a la salida
cuatro  BCF     estado,0	; pone a 0 el bit C de status (carry)
	CALL    clokon
	MOVWF	portb		; lo enva a la salida
        RRF     portb,0		; rota a la izquierda y pasa el valor a W
	MOVWF	portb		; lo enva a la salida
	CALL	clokon
	CLRF	portb		; (00000000)
	CALL	clokon
	MOVWF	portb		; repite
	CALL	clokon
	CLRF	portb		; (00000000)
	CALL	clokon
	MOVWF	portb		; lo enva a la salida
        BTFSS   portb,0		; ve si termin de rotar
        GOTO    cuatro
	CALL	clokon
	RETURN

efect16	CLRF    portb		; limpia el puerto B
        BSF     portb,7		; (10000000)
        BCF     estado,0	; pone a 0 el bit C de status (el 1 bit)
seis    CALL    clokon
        RRF     portb,1		; rota a la derecha
        BTFSS   portb,0		; ve si termin de rotar
        GOTO    seis
        CLRF    portb		; (00000000)
        BSF     portb,0		; (00000001)
        BCF     estado,0	; pone el carry a 0
siete   CALL    clokon
        RLF     portb,1		; rota a la izquierda
        BTFSS   portb,7		; ve si termin de rotar
        GOTO    siete		
	CALL    clokon       
	RETURN	

;============ control de pulsos de clock ==================

clokon	BTFSS   PORTA,4		; prueba si es 1 
        GOTO    clokon		; sino espera
clokoff BTFSC   PORTA,4		; prueba si termina el pulso
        GOTO    clokoff		; sino espera que termine
        RETURN			; regresa y contina

;========================= final ==========================

	END
